% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_adv_e.R
\name{autoenc_adv_e}
\alias{autoenc_adv_e}
\title{Adversarial Autoencoder - Encode}
\usage{
autoenc_adv_e(
  input_size,
  encoding_size,
  batch_size = 350,
  num_epochs = 1000,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}
}
\value{
A \code{autoenc_adv_e} object.
}
\description{
Creates a deep learning adversarial autoencoder (AAE) to encode sequences
of observations. Wraps a PyTorch implementation.
}
\details{
Adversarial autoencoders regularize the latent space using an adversarial
training objective, encouraging the aggregated posterior to match a prior distribution.
This can lead to more structured latent representations.
}
\examples{
\dontrun{
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)
ae <- autoenc_adv_e(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)       # adversarially-regularized encoder
Z  <- daltoolbox::transform(ae, X) # encodings
dim(Z)
}

# See a complete example:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_adv_e.md
}
\references{
Makhzani, A., Shlens, J., Jaitly, N., Goodfellow, I., & Frey, B. (2016).
Adversarial Autoencoders.
}
