% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{hist.coefs_dm}
\alias{hist.coefs_dm}
\title{Plot Parameter Distribution(s)}
\usage{
\method{hist}{coefs_dm}(
  x,
  ...,
  conds = NULL,
  col = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "value",
  ylab = NULL,
  bundle_plots = TRUE
)
}
\arguments{
\item{x}{an object of class \code{coefs_dm} (see \link{coef.fits_ids_dm})}

\item{...}{additional graphical arguments passed to \code{\link[graphics:hist]{graphics::hist()}}.
Not supported are the \code{plot} and \code{probability} arguments
(the latter can be controlled via the supported \code{freq} argument).
For further plotting arguments, see also \code{\link[=set_default_arguments]{set_default_arguments()}}.}

\item{conds}{a character vector specifying the conditions to plot.
Defaults to all available conditions.}

\item{col}{character vector, specifying colors for each condition, if
conditions are present.}

\item{xlim}{a numeric vector of length 2, specifying the x-axis limits.}

\item{ylim}{a numeric vector of length 2, specifying the y-axis limits.}

\item{xlab, ylab}{character strings for the x- and y-axis labels.}

\item{bundle_plots}{logical, indicating whether to display separate panels
in a single plot layout (\code{FALSE}), or to plot them separately (\code{TRUE}).}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
This function creates a histogram for each parameter in a \code{coefs_dm} object,
resulting from a call to \link{coef.fits_ids_dm}.
}
\details{
The \code{hist.coefs_dm} function is designed for visualizing parameter
distributions.

If multiple conditions are present, it overlays histograms for each condition
with adjustable transparency.

When \code{bundle_plots} is set to \code{TRUE}, histograms for each parameter are
displayed in a grid layout within a single graphics device.

This function has some customization options, but they are limited. If you
want to have a highly customized histogram, it is best to create it on your
own using R's \code{\link[graphics:hist]{graphics::hist()}} function (see the examples below).
}
\examples{
# get an auxiliary fit procedure result (see the function load_fits_ids)
all_fits <- get_example_fits("fits_ids")
coefs <- coef(all_fits)
print(coefs)
hist(coefs, bundle_plots = FALSE) # calls hist.coefs_dm method of dRiftDM

# how to fall back to R's hist() function for heavy customization
coefs <- unpack_obj(coefs) # provides the plain data.frame
hist(coefs$muc, main = expression(mu[c])) # calls graphics::hist()

}
