% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_formulas.R
\name{reconstruct_formulas}
\alias{reconstruct_formulas}
\title{Reconstruct model formulas from results tibbles}
\usage{
reconstruct_formulas(results, topn = NULL)
}
\arguments{
\item{results}{\code{data.frame} with results from
\code{\link[cvms:cross_validate]{cross_validate()}}
 or \code{\link[cvms:validate]{validate()}}. (tbl)

 Must contain at least the columns \code{"Dependent"} and \code{"Fixed"}. For random effects,
 the \code{"Random"} column should be included.}

\item{topn}{Number of top rows to return. Simply applies \code{head()} to the results \code{tibble}.}
}
\value{
\code{list} of model formulas.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

 In the (cross-)validation results from functions like
 \code{\link[cvms:cross_validate]{cross_validate()}},
 the model formulas have been split into the columns
 \code{Dependent}, \code{Fixed} and \code{Random}.
 Quickly reconstruct the model formulas from these columns.
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
