% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{irr_safe}
\alias{irr_safe}
\title{Robust internal rate of return (adaptive bracketing)}
\usage{
irr_safe(
  cf,
  lower = -0.9999,
  upper = 0.1,
  max_upper = 10000,
  tol = sqrt(.Machine$double.eps),
  warn = FALSE
)
}
\arguments{
\item{cf}{Numeric. Vector of cash flows \eqn{t = 0, \dots, T}.}

\item{lower, upper}{Initial search bounds for the IRR (decimal rates).}

\item{max_upper}{Maximum upper bound when automatically expanding the
bracketing interval.}

\item{tol}{Numerical tolerance passed to \code{\link[stats]{uniroot}}.}

\item{warn}{Logical. If \code{TRUE}, emits a warning when the IRR cannot be
computed (no sign change or failure of bracketing).}
}
\value{
A numeric scalar (decimal rate) corresponding to the IRR, or
\code{NA_real_} if the IRR is not defined or could not be located
numerically.
}
\description{
Computes a real IRR from a vector of dated cash flows \eqn{t = 0, \dots, T}.
The algorithm first searches for a root in an initial interval
\code{[lower, upper]}. If this interval does not \emph{bracket} a root
(that is, if the net present value function does not change sign),
the upper bound is expanded multiplicatively up to \code{max_upper}.

If the cash-flow series exhibits no sign change (all flows are
\code{>= 0} or all \code{<= 0}), or if no root can be bracketed after
expansion, the function silently returns \code{NA_real_} (optionally
with a warning if \code{warn = TRUE}).
}
\examples{
irr_safe(c(-100, 60, 60))   # IRR defined
irr_safe(c(-100, -20, -5))  # no sign change -> NA

}
