% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cpr_cpr.R
\name{summary.cpr_cpr}
\alias{summary.cpr_cpr}
\title{Summarize a Control Polygon Reduction Object}
\usage{
\method{summary}{cpr_cpr}(object, ...)
}
\arguments{
\item{object}{a \code{cpr_cpr} object}

\item{...}{pass through}
}
\value{
a \code{data.frame} with the attribute \code{elbow} which is a
programmatic attempt to identify a useful trade-off between degrees of freedom
and fit statistic.
}
\description{
Summarize a Control Polygon Reduction Object
}
\examples{

set.seed(42)
x <- seq(0 + 1/5000, 6 - 1/5000, length.out = 100)
bmat <- bsplines(x, iknots = c(1, 1.5, 2.3, 4, 4.5), bknots = c(0, 6))
theta <- matrix(c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5), ncol = 1)
DF <- data.frame(x = x, truth = as.numeric(bmat \%*\% theta))
DF$y <- as.numeric(bmat \%*\% theta + rnorm(nrow(bmat), sd = 0.3))

initial_cp <-
  cp(y ~ bsplines(x, iknots = c(1, 1.5, 2.3, 3.0, 4, 4.5), bknots = c(0, 6))
     , data = DF
     , keep_fit = TRUE # default is FALSE
  )

cpr0 <- cpr(initial_cp)
s <- summary(cpr0)
s
plot(s, type = "rse")

}
