% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation_tests.R
\name{deltaR2_ou}
\alias{deltaR2_ou}
\title{Incremental R-squared from X in OU model}
\usage{
deltaR2_ou(
  results_robust,
  lag = 1,
  oos = TRUE,
  seed = 123,
  ridge = 1e-08,
  verbose = TRUE
)
}
\arguments{
\item{results_robust}{Output from run_complete_factor_analysis_robust()}

\item{lag}{Number of lags for the model (default: 1)}

\item{oos}{Logical, perform out-of-sample validation (default: TRUE)}

\item{seed}{Random seed for reproducibility (default: 123)}

\item{ridge}{Ridge regularization parameter (default: 1e-08)}

\item{verbose}{Logical, print progress messages (default: TRUE)}
}
\value{
List with components:
\describe{
\item{\code{in_sample}}{Data frame with R2_full, R2_baseline, and deltaR2.}
\item{\code{per_equation}}{Vector of deltaR2 for each Y factor equation.}
\item{\code{OOS}}{List with out-of-sample RMSE and deltaR2 (if \code{oos = TRUE}).}
}
}
\description{
Computes the incremental explanatory power (delta R-squared) contributed by
X factors in predicting Y factors, both in-sample and out-of-sample.
}
