% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{toy}
\alias{toy}
\title{Toy dataframe with varying levels of multicollinearity}
\format{
dataframe with 2000 rows and 5 columns.
}
\usage{
data(toy)
}
\description{
Dataframe with known relationship between responses and predictors useful to illustrate multicollinearity concepts.
}
\details{
Columns:
\itemize{
\item \code{y}: response variable generated from \code{a * 0.75 + b * 0.25 + noise}.
\item \code{a}: most important predictor of \code{y}, uncorrelated with \code{b}.
\item \code{b}: second most important predictor of \code{y}, uncorrelated with \code{a}.
\item \code{c}: generated from \code{a + noise}.
\item \code{d}: generated from \code{(a + b)/2 + noise}.
}

These are variance inflation factors of the predictors in \code{toy}.
variable vif
b       4.062
d       6.804
c       13.263
a       16.161
}
\seealso{
Other example_data: 
\code{\link{vi}},
\code{\link{vi_predictors}},
\code{\link{vi_predictors_categorical}},
\code{\link{vi_predictors_numeric}},
\code{\link{vi_responses}},
\code{\link{vi_smol}}
}
\concept{example_data}
\keyword{datasets}
