% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{pca_plot}
\alias{pca_plot}
\title{pca_plot}
\usage{
pca_plot(results, overlaid.info, sample.names = NULL, show.names = TRUE)
}
\arguments{
\item{results}{cinaR result object}

\item{overlaid.info}{overlaid information onto the samples}

\item{sample.names}{names of the samples shown on pca plot}

\item{show.names}{logical, if set FALSE sample names will be hidden}
}
\value{
ggplot object
}
\description{
pca_plot
}
\examples{

#' library(cinaR)
data(atac_seq_consensus_bm) # calls 'bed'

# creating dummy results
results <- NULL
results[["cp"]] <- bed[,c(4:25)]

# a vector for comparing the examples
contrasts <- sapply(strsplit(colnames(bed), split = "-", fixed = TRUE),
                    function(x){x[1]})[4:25]

## overlays the contrasts info onto PCA plots
pca_plot(results, contrasts)

## you can overlay other information as well,
## as long as it is the same length with the
## number of samples.

sample.info <- c(rep("Group A", 11), rep("Group B", 11))
pca_plot(results, sample.info, show.names = FALSE)

}
