% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_xifti.R
\name{impute_xifti}
\alias{impute_xifti}
\title{Impute \code{"xifti"} data}
\usage{
impute_xifti(
  xifti,
  mask = NULL,
  impute_FUN = function(x) {
     mean(x, na.rm = TRUE)
 },
  ...
)
}
\arguments{
\item{xifti}{A \code{"xifti"} object. The corresponding surface must be
included for each cortex with data. \code{\link{add_surf}} can be used to
add HCP S1200 surfaces.}

\item{mask}{A logical vector whose length matches the number of rows in
\code{xifti}, indicating which locations in \code{xifti} to impute.
(Locations that are \code{TRUE} will be imputed.)

If \code{NULL} (default), will use the mask of locations with at least one
\code{NA} and \code{NaN} value across the columns of \code{xifti}. The
\code{NA} and \code{NaN} locations will be replaced with numeric values
(except in the case of any voxels with no immediate neighbors).

On the other hand, if \code{mask} is provided, the \code{NA} and \code{NaN}
values originally in \code{xifti}, and not in \code{mask}, will be left
alone. Only locations in \code{mask} will be imputed.}

\item{impute_FUN}{The function to use to impute the values. It should accept
a vector of numeric values (the values of neighboring locations) and return
a single numeric value (the value to assign). Default: \code{mean(..., na.rm=TRUE)}.}

\item{...}{Additional arguments to \code{impute_FUN}.}
}
\value{
The input \code{xifti} with imputed data values.
}
\description{
Impute locations using the values of neighboring locations.
}
\details{
Cortex vertices will be imputed using the five or six other vertices which
share a face. Subcortex voxels will be imputed using the up to six immediate
neighbors.

Note that during imputation, locations in \code{mask}, as well as the medial
wall for the cortex, are temporarily set to \code{NA}.

Note that handling of \code{NA} values and the mask slightly differs from
the cortex and subcortex. \code{impute_FUN} like \code{mean} will behave
similarly, but functions which change depending on the amount of neighbor
locations with \code{NA} values may differ.
\code{impute_FUN} should handle \code{NA} values accordingly.
For most use cases, it will make sense to pass \code{na.rm=TRUE} to
\code{...} if \code{impute_FUN} is a summary function like \code{mean}.
}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_xifti}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
