% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R
\name{cast}
\alias{cast}
\alias{cast_common}
\alias{archetype}
\alias{archetype_common}
\alias{r_type}
\alias{r_type_common}
\title{Fast casting/coercing of R objects}
\usage{
cast(x, archetype)

cast_common(..., .args = NULL)

archetype(x)

archetype_common(..., .args = NULL)

r_type(x)

r_type_common(..., .args = NULL)
}
\arguments{
\item{x}{A vector.}

\item{archetype}{An archetype vector.}

\item{...}{Vectors.}

\item{.args}{An alternative to \code{...} so you can supply arguments directly
in a list. \cr
This is equivalent to \code{do.call(f, .args)} but much more efficient.}
}
\value{
\code{cast()} will attempt to cast \code{x} into an object similar to \code{archetype}. \cr
\code{cast_common()} coerces all supplied vectors into a
common type between them. \cr
\code{archetype()} returns the zero-length template/archetype of \code{x}. \cr
\code{archetype_common()} returns the common zero-length
template between all supplied vectors. \cr
\code{r_type()} will return the internal cheapr-defined type of \code{x} as a
character vector of length 1. This will usually match \code{class(x)}
but not always. \cr
\code{r_type_common()} returns the common type between all objects.
}
\description{
\code{cast_common()} is type-commutative, meaning the order of objects doesn't
affect the outcome type.
\code{cast()} will attempt to cast \code{x} into an object similar to \code{archetype}.
}
