% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_authentication_tokens.R
\name{get_authentication_tokens}
\alias{get_authentication_tokens}
\title{Get Authentication Tokens}
\usage{
get_authentication_tokens(
  app_key,
  redirect_uri,
  app_secret,
  token_save_path = getwd()
)
}
\arguments{
\item{app_key}{application key generated by Charles Schwab (character)}

\item{redirect_uri}{redirect URI specified when registering application (character)}

\item{app_secret}{application secret generated by Charles Schwab (character)}

\item{token_save_path}{path to current token or where you would like token stored. Default is the working directory (character)}
}
\value{
Returns a message on whether the authentication
        was successful or not along with token information
        (if successful, NULL otherwise), including the path
        to where the token RDS object is saved.
}
\description{
Given the app key, redirect uri, and app secret, this function
will walk the user through the process to gather the appropriate
authentication tokens (access token and refresh token) and store
them in the user's specified location (if no location is specified,
it will store the tokens in the user's working directory). Note that
the tokens are saved in an RDS file via a list since additional
metadata is captured in addition to the tokens (such as the expiration
of those tokens to help with knowing when to refresh). After this function
is initially called, be sure use the same path to the token for future calls
along with maintaining the default name that is used for
the RDS file to avoid manual reauthentication whenever possible.
This function will always first look to see if an RDS file exists
at the specified path and with the default name to check if tokens
are valid or expired. Authentication requires no user intervention
when the refresh token is valid. User intervention (via the login
method through a separate browser) is only required when both the
access token and the refresh token are expired.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, June 2024
}
\keyword{authentication}
\keyword{tokens}
