% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_deutschlandatlas.R
\name{deutschlandatlas_query}
\alias{deutschlandatlas_query}
\title{Query Deutschlandatlas indicators}
\usage{
deutschlandatlas_query(
  table = "p_apo_f_ZA2022",
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{table}{Table id (default "p_apo_f_ZA2022").}

\item{params}{Query parameters for the ArcGIS service.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with indicator records.
}
\description{
Query Deutschlandatlas indicators
}
\details{
The Deutschlandatlas API is backed by an ArcGIS feature service. You must
supply a \code{where} filter and output format \code{f} (usually "json"). Official docs:
https://github.com/AndreasFischer1985/deutschlandatlas-api.
}
\examples{
\dontrun{
deutschlandatlas_query(
  table = "p_apo_f_ZA2022",
  params = list(
    where = "1=1",
    outFields = "*",
    f = "json",
    returnGeometry = "false",
    resultRecordCount = 5
  )
)
}

}
\seealso{
\code{\link[=bunddev_parameters]{bunddev_parameters()}} to inspect available query parameters.
}
