% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.r
\name{fmt}
\alias{fmt}
\alias{chr}
\alias{html_escape}
\alias{interleave}
\title{String formatting helpers}
\usage{
fmt(..., envir = parent.frame())

chr(x)

html_escape(x)

interleave(a, b)
}
\arguments{
\item{\dots}{one or more unnamed character string arguments, followed
optionally by named arguments}

\item{x}{an object to convert}

\item{a}{a character vector of length \code{n}}

\item{b}{a character vector of length \code{n - 1}}
}
\value{
\code{fmt(\dots)} concatenates any unnamed arguments, and
interpolates all embedded expressions as explained in the \sQuote{Details}.
Named arguments are treated as locally defined variables, and are added to
(and override, in case of name reuse) names defined in the calling scope.

\code{chr(x)} returns a string representation of a value or
unevaluated expression \code{x}.

\code{html_escape(x)} returns the HTML-escaped version of \code{x}.

\code{interleave(a, b)} returns a vector \code{c(a[1], b[1], a[2],
b[2], \dots, a[n - 1], b[n - 1], a[n])}.
}
\description{
Interpolate expressions in a string
}
\details{
\code{fmt} interpolates embedded expressions in a string.
\code{chr} converts a value to a character vector; unlike
\code{as.character}, it correctly deparses unevaluated names and expressions.
\code{interleave} is a helper that interleaves two vectors \code{a = c(a[1],
\dots, a[n])} and \code{b = c(b[1], \dots, b[n - 1])}.

The general format of an interpolation expression inside a \code{fmt} string
is: \code{\{\dots\}} interpolates the expression \code{\dots}. To insert
literal braces, double them (i.e. \code{\{\{}, \code{\}\}}). Interpolated
expressions can optionally be followed by a \emph{format modifier}: if
present, it is specified via the syntax \code{\{\dots;modifier\}}. The
following modifiers are supported:
\describe{
 \item{\code{\"}}{like \code{dQuote(\dots)}}
 \item{\code{\'}}{like \code{sQuote(\dots)}}
 \item{\code{‹fmt›f}}{like \code{sprintf('\%‹fmt›f', \dots)}}
}
Vectors of length > 1 will be concatenated as if using
\code{\link[base]{toString}} before interpolation.
}
\keyword{internal}
