% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{generic_distribution_functions}
\alias{generic_distribution_functions}
\alias{cdf}
\alias{logcdf}
\alias{pdf}
\alias{logpdf}
\alias{hazard}
\alias{chf}
\alias{mode}
\alias{standard_deviation}
\alias{support}
\alias{variance}
\alias{skewness}
\alias{kurtosis}
\alias{kurtosis_excess}
\title{Generic Distribution Functions}
\usage{
cdf(x, ...)

logcdf(x, ...)

pdf(x, ...)

logpdf(x, ...)

hazard(x, ...)

chf(x, ...)

mode(x, ...)

standard_deviation(x, ...)

support(x, ...)

variance(x, ...)

skewness(x, ...)

kurtosis(x, ...)

kurtosis_excess(x, ...)
}
\arguments{
\item{x}{A distribution object created by a distribution constructor function.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, quantile, mean, median, mode, range, standard deviation, support, variance, skewness, kurtosis, or excess kurtosis depending on the function called.
}
\description{
Generic functions for computing various properties of statistical distributions.
}
\examples{
# Create a Weibull distribution
weibull_dist <- weibull_distribution(shape = 2, scale = 1)
# Compute the CDF at a specific point
cdf(weibull_dist, 1)
# Check support
support(weibull_dist)
}
