% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{export_results}
\alias{export_results}
\title{Export Analysis Results}
\usage{
export_results(results, output_dir, format = "xlsx", verbose = TRUE)
}
\arguments{
\item{results}{Named list containing analysis results. Expected components
include: hurdle, te, te_by_type (list with counts/rates/binary), placebo,
tvarstar, varx, eba, dbn_arcs, hmm, sensemakr_I, sensemakr_C, oos, ate.}

\item{output_dir}{Directory path for output files. Created if it does not exist.}

\item{format}{Character; output format. One of "xlsx", "csv", or "both".}

\item{verbose}{Logical; if TRUE, print progress messages.}
}
\value{
Invisible path to output directory.
}
\description{
Exports analysis results to Excel and/or CSV format.
}
\examples{
\donttest{
results <- list(
  hurdle = data.frame(model = "test", elpd = -100),
  te = data.frame(dir = "I->C", stat = 0.5, p_value = 0.01)
)
export_results(results, tempdir(), format = "both")
}
}
