% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_split_plan.R
\name{show,LeakSplits-method}
\alias{show,LeakSplits-method}
\title{Display summary for LeakSplits objects}
\usage{
\S4method{show}{LeakSplits}(object)
}
\arguments{
\item{object}{LeakSplits object.}
}
\value{
No return value, called for side effects (prints a summary to the
  console showing mode, fold count, repeats, outcome, stratification status,
  nested status, per-fold train/test sizes, and the reproducibility hash).
}
\description{
Prints fold counts, sizes, and hash metadata for quick inspection.
}
\examples{
df <- data.frame(
  subject = rep(1:10, each = 2),
  outcome = rbinom(20, 1, 0.5),
  x1 = rnorm(20),
  x2 = rnorm(20)
)
splits <- make_split_plan(df, outcome = "outcome",
                      mode = "subject_grouped", group = "subject", v = 5)
show(splits)
}
