% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidecar.R
\name{infer_tr}
\alias{infer_tr}
\alias{infer_tr.character}
\title{Infer TR (Repetition Time) from a BOLD file or sidecar}
\usage{
infer_tr(x, ...)

\method{infer_tr}{character}(
  x,
  prefer = c("json", "nifti"),
  fallback = TRUE,
  coerce_units = c("strict", "auto"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{A character path to a BOLD \code{.nii[.gz]} file or its \code{.json} sidecar,
or a \code{bids_project} object.}

\item{...}{Additional arguments passed to methods.}

\item{prefer}{Preferred source of TR: \code{"json"} (default) or \code{"nifti"}.}

\item{fallback}{If TRUE (default), attempt NIfTI header fallback when JSON is
not available or incomplete.}

\item{coerce_units}{Unit handling for non-compliant values. \code{"strict"}
(default) assumes seconds as per BIDS and returns values as-is. \code{"auto"}
will convert clearly millisecond-like values to seconds (divide by 1000)
and annotate the conversion in the return value's attributes.}

\item{verbose}{If TRUE, print informative messages when falling back or when
encountering special cases (e.g., SBRef files).}
}
\value{
Numeric TR in seconds, or \code{NA_real_} if it cannot be determined. The
return value includes attributes: \code{source} (e.g., \code{json:RepetitionTime},
\code{json:VolumeTiming}, \code{nifti:pixdim4}), \code{path} (the file used), and
optionally \code{variable = TRUE} if \code{VolumeTiming} indicates non-constant TR; a
\code{unit = "ms->s"} attribute is added if units were auto-converted.
}
\description{
Given a path to a BOLD NIfTI file (\verb{*.nii} or \verb{*.nii.gz}) or its JSON
sidecar (\verb{*.json}), this function locates the appropriate sidecar JSON and
returns the TR (in seconds). It prefers the JSON \code{RepetitionTime} field
(BIDS-compliant). If that is not available, it falls back to computing TR as
the median difference of \code{VolumeTiming} (if present). Optionally, when the
sidecar cannot be found or is missing both fields, the function attempts to
read TR from the NIfTI header (pixdim[4]) if an appropriate reader is
installed.
}
\details{
For NIfTI inputs, the JSON sidecar is resolved by replacing the
\verb{*.nii}/\verb{*.nii.gz} suffix with \code{.json} in the same directory. If that file is
not found, the function searches the directory for a \code{.json} file with the
same stem (filename without the NIfTI extension).
}
\examples{
tmp_json <- tempfile(fileext = ".json")
writeLines('{"RepetitionTime": 2}', tmp_json)
infer_tr(tmp_json)
unlink(tmp_json)

tmp_json2 <- tempfile(fileext = ".json")
writeLines('{"VolumeTiming": [0, 2, 4, 6]}', tmp_json2)
infer_tr(tmp_json2)
unlink(tmp_json2)
}
