% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bidsio.R, R/mock_bids.R
\name{confound_files}
\alias{confound_files}
\alias{confound_files.bids_project}
\alias{confound_files.mock_bids_project}
\title{Get confound files from a BIDS project}
\usage{
confound_files(x, ...)

\method{confound_files}{bids_project}(x, subid = ".*", task = ".*", session = ".*", ...)

\method{confound_files}{mock_bids_project}(
  x,
  subid = ".*",
  task = ".*",
  session = ".*",
  run = ".*",
  full_path = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{...}{Additional arguments passed to \code{search_files}.}

\item{subid}{Regex pattern for subject IDs. Default \code{".*"}.}

\item{task}{Regex pattern for task names. Default \code{".*"}.}

\item{session}{Regex pattern for session IDs. Default \code{".*"}.}

\item{run}{Regex pattern for run indices. Default \code{".*"}.}

\item{full_path}{If \code{TRUE}, return full paths (prefixed with \code{x$path}).
If \code{FALSE} (default), return relative paths.}
}
\value{
A character vector of file paths to confound files matching the specified criteria.
If no matching files are found, returns NULL.

A character vector of file paths

A character vector of relative or full paths to potential confound files,
or \code{NULL} if none are found.
}
\description{
This function retrieves a vector of confound files from a BIDS project that match
specified criteria. Confound files in BIDS derivatives (typically from fMRIPrep)
contain nuisance variables that can be used for denoising fMRI data, such as
motion parameters, physiological signals, and other noise components.

Searches the mock BIDS structure for files matching typical confound file patterns
(e.g., \verb{*_confounds*.tsv}, \verb{*_regressors*.tsv}, \verb{*_timeseries*.tsv})
within the derivatives directory.
}
\details{
This function assumes confound files reside in the derivatives path
specified by \code{x$prep_dir} and were defined in the \code{file_structure}
passed to \code{create_mock_bids} with \code{fmriprep=TRUE}.
}
\examples{
\donttest{
# Get all confound files from a BIDS project with fMRIPrep derivatives
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep=TRUE)
  conf_files <- confound_files(proj)
  
  # Get confound files for specific subjects and tasks
  confound_files(proj, subid="sub-01", task="balloonanalogrisktask")
  
  # Clean up
  unlink(ds_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
# Setup mock project with a derivative confound file
participants_df <- tibble::tibble(participant_id = "01")
file_structure_df <- tibble::tribble(
  ~subid, ~session, ~datatype, ~task, ~run, ~suffix, ~fmriprep, ~desc,
  "01",   NA,       "func",    "taskA", "01", 
  "desc-confounds_timeseries.tsv", TRUE, "confounds"
)
mock_proj <- create_mock_bids("ConfoundMock", participants_df, file_structure_df)

# Find confound files
confound_files(mock_proj)

# Find for specific subject
confound_files(mock_proj, subid="01")
}
