% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids_subject.R
\name{bids_subject}
\alias{bids_subject}
\alias{bids_subject.bids_project}
\title{Access a single subject from a BIDS project}
\usage{
bids_subject(x, subid, ...)

bids_subject.bids_project(x, subid, ...)

bids_subject(x, subid, ...)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{subid}{Character string. The subject ID to extract (without the "sub-" prefix).}

\item{...}{Additional arguments (not currently used).}
}
\value{
A list of helper functions for the subject.

A list containing subject-specific helper functions. Each function
automatically filters results for the specified subject. The returned object
contains the following callable functions:
\describe{
\item{\code{events(...)}}{
Returns nested tibble with event data for this subject.
Equivalent to \code{read_events(project, subid = "XX", ...)}.
Additional arguments (task, session, run, nest, etc.) can be passed.
}
\item{\code{event_files(...)}}{
Returns character vector of event file paths for this subject.
Equivalent to \code{event_files(project, subid = "XX", ...)}.
Additional arguments (task, session, run, full_path, etc.) can be passed.
}
\item{\code{scans(...)}}{
Returns character vector of functional scan file paths for this subject.
Equivalent to \code{func_scans(project, subid = "XX", ...)}.
Additional arguments (task, session, run, kind, full_path, etc.) can be passed.
}
\item{\code{confounds(...)}}{
Returns confound data for this subject (requires fMRIPrep derivatives).
Equivalent to \code{read_confounds(project, subid = "XX", ...)}.
Additional arguments (task, session, run, cvars, npcs, etc.) can be passed.
}
\item{\code{preproc_scans(...)}}{
Returns preprocessed scan paths for this subject (requires fMRIPrep derivatives).
Equivalent to \code{preproc_scans(project, subid = "XX", ...)}.
Additional arguments (task, session, run, space, variant, etc.) can be passed.
}
\item{\code{brain_mask(...)}}{
Creates brain mask for this subject (requires fMRIPrep derivatives).
Equivalent to \code{brain_mask(project, subid = "XX", ...)}.
Additional arguments (thresh, etc.) can be passed.
}
}

A new \code{bids_project} object containing only the specified subject's data.
Returns NULL if the subject is not found in the project.
}
\description{
\code{bids_subject} returns a lightweight interface with helper functions
for retrieving data associated with one subject.

\code{bids_subject} returns a lightweight facade that exposes convenience
functions to work with all data associated with one subject within a
BIDS project.

This function extracts a single subject's data from a BIDS project, creating
a new BIDS project object containing only that subject's files and metadata.
}
\examples{
\donttest{
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  subj <- bids_subject(proj, "01")
  subj$events()
  subj$scans()
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
\donttest{
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  
  # Create subject interface for subject 01
  subj <- bids_subject(proj, "01")
  
  # Get functional scan paths for this subject
  scan_paths <- subj$scans()
  print(paste("Subject 01 has", length(scan_paths), "functional scans"))
  
  # Get event file paths for this subject
  event_paths <- subj$event_files()
  print(paste("Subject 01 has", length(event_paths), "event files"))
  
  # Read event data for this subject
  event_data <- subj$events()
  print("Event data structure:")
  print(event_data)
  
  # You can still pass additional filtering arguments
  # For example, get only specific tasks:
  task_scans <- subj$scans(task = "balloonanalogrisktask")
  
  # Dataset cache is intentionally retained for performance.
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
\donttest{
# Create a subject interface
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  
  # Create subject interface for subject 01  
  subj <- bids_subject(proj, "01")
  
  # Use the helper functions
  scans <- subj$scans()
  events <- subj$event_files()
  print(paste("Subject 01:", length(scans), "scans,", length(events), "events"))
  
  # Dataset cache is intentionally retained for performance.
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}

}
