% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.summary.brs}
\alias{print.summary.brs}
\title{Print a model summary (betareg style)}
\usage{
\method{print}{summary.brs}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{A \code{"summary.betaregscale"} object.}

\item{digits}{Number of digits.}

\item{...}{Passed to \code{printCoefmat}.}
}
\value{
Invisibly returns the input object \code{x}. The function is called
  for its side effect of printing a comprehensive summary to the console,
  including the model call, quantile residuals, coefficient tables for mean
  and precision submodels with significance stars, goodness-of-fit statistics
  (log-likelihood, pseudo R-squared), optimization details, and censoring
  information.
}
\description{
Print a model summary (betareg style)
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
print(summary(fit))
}

}
\seealso{
\code{\link{summary.brs}}, \code{\link{brs}},
  \code{\link{print.brs}}
}
