% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.brs}
\alias{plot.brs}
\title{Diagnostic plots for beta interval regression}
\usage{
\method{plot}{brs}(
  x,
  which = 1:4,
  type = "rqr",
  nsim = 100L,
  level = 0.9,
  caption = c("Residuals vs indices", "Cook's distance", "Residuals vs linear predictor",
    "Residuals vs fitted values", "Half-normal plot", "Predicted vs observed"),
  sub.caption = NULL,
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  gg = FALSE,
  title = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted \code{"brs"} object.}

\item{which}{Integer vector selecting which plots to draw
(default \code{1:4}).}

\item{type}{Character: residual type passed to
\code{\link{residuals.brs}} (default \code{"rqr"}).}

\item{nsim}{Integer: number of simulations for the half-normal
envelope (default 100).}

\item{level}{Numeric: confidence level for the envelope
(default 0.9).}

\item{caption}{Character vector of panel captions.}

\item{sub.caption}{Subtitle; defaults to the model call.}

\item{ask}{Logical: prompt before each page of plots?}

\item{gg}{Logical: use ggplot2? (default \code{FALSE}).}

\item{title}{Optional global title for ggplot output. If \code{NULL},
panel captions are used.}

\item{theme}{Optional ggplot2 theme object (e.g., \code{ggplot2::theme_bw()}).
If \code{NULL}, a minimal theme is used.}

\item{...}{Further arguments passed to base \code{plot()}.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Produces up to six diagnostic plots for a fitted
\code{"brs"} model: residuals vs indices, Cook's
distance, residuals vs linear predictor, residuals vs fitted
values, a half-normal plot with simulated envelope, and
predicted vs observed.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
plot(fit, which = 1:4)
}

}
\seealso{
\code{\link{brs}}, \code{\link{residuals.brs}},
  \code{\link{autoplot.brs}}
}
