% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{model.matrix.brsmm}
\alias{model.matrix.brsmm}
\title{Extract design matrix}
\usage{
\method{model.matrix}{brsmm}(object, model = c("mean", "precision", "random"), ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{model}{Character: \code{"mean"} (default), \code{"precision"}, or \code{"random"}.}

\item{...}{Ignored.}
}
\value{
The design matrix for the specified submodel.
}
\description{
Extract design matrix
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
head(model.matrix(fit))
head(model.matrix(fit, model = "random"))
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{formula.brsmm}}
}
