% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_release_address}
\alias{ec2_release_address}
\title{Release Address}
\usage{
ec2_release_address(
  AllocationId = NULL,
  PublicIp = NULL,
  NetworkBorderGroup = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{AllocationId}{Character. [EC2-VPC] The allocation ID. Required for EC2-VPC.[optional]}

\item{PublicIp}{Character. [EC2-Classic] The Elastic IP address. Required for EC2-Classic.[optional]}

\item{NetworkBorderGroup}{Character.   The set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses....[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Release Address
}
\section{AllocationId}{

[EC2-VPC] The allocation
ID. Required for EC2-VPC.
}

\section{PublicIp}{

[EC2-Classic] The
Elastic IP address. Required for EC2-Classic.
}

\section{NetworkBorderGroup}{


The set of Availability Zones, Local Zones, or Wavelength Zones from
which AWS advertises IP addresses.

If you provide an incorrect network border group, you will receive an
\code{InvalidAddress.NotFound} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 classic, you will receive an
\code{InvalidParameterCombination} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

