% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_get}
\alias{am_get}
\title{Get a value from an Automerge map or list}
\usage{
am_get(doc, obj, key)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (from nested object), or \code{AM_ROOT}
for the document root}

\item{key}{For maps: character string key. For lists: numeric index
(1-based). Returns \code{NULL} for indices \verb{<= 0} or beyond list length.}
}
\value{
The value at the specified key/position, or \code{NULL} if not found.
Nested objects are returned as \code{am_object} instances.
}
\description{
Retrieves a value from an Automerge map or list. Returns \code{NULL}
if the key or index doesn't exist.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "name", "Alice")

name <- am_get(doc, AM_ROOT, "name")
name  # "Alice"

am_close(doc)

}
