% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labellers.R
\name{label_wrap_jp}
\alias{label_wrap_jp}
\alias{label_wrap_jp_gen}
\title{Japanese word-wrapping labeller for ggplot2}
\usage{
label_wrap_jp(labels, wrap = 16, width = 50, collapse = "\\n")

label_wrap_jp_gen(wrap = 16, width = 50, collapse = "\\n")
}
\arguments{
\item{labels}{A character vector of labels to wrap.}

\item{wrap}{An integer giving the target number of characters per line.}

\item{width}{An integer giving the maximum total width of the wrapped label.}

\item{collapse}{A character string used to join wrapped lines.}
}
\value{
\itemize{
\item \code{label_wrap_jp()} returns a character vector of wrapped labels.
\item \code{label_wrap_jp_gen()} returns a labeller function for use in ggplot2 scales.
}
}
\description{
Wraps character strings using Japanese phrase boundaries and returns
labels suitable for use with ggplot2 scales.
}
\details{
This labeller uses ICU-based Japanese phrase boundary detection to
insert line breaks at natural word boundaries. Long labels can be
truncated to a fixed display width with an ellipsis.
}
\examples{
label_wrap_jp(polano[4:6], width = 32)
\dontrun{
if (requireNamespace("scales", quietly = TRUE)) {
  scales::demo_discrete(polano[4:6], labels = label_wrap_jp_gen())
}
}
}
