% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agronomic_analysis.R
\name{crop_growth_analysis}
\alias{crop_growth_analysis}
\title{Crop Growth Analysis (CGR, RGR, NAR, LAI)}
\usage{
crop_growth_analysis(dry_weight, leaf_area, days, verbose = TRUE)
}
\arguments{
\item{dry_weight}{Vector of dry matter at different stages}

\item{leaf_area}{Vector of leaf area at different stages}

\item{days}{Vector of days after sowing}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
Data frame with growth parameters
}
\description{
Calculates crop growth parameters from sequential harvest data.
}
\examples{
dry_weight <- c(0.5, 2.1, 8.5, 25, 45, 62, 75)
leaf_area <- c(15, 85, 350, 800, 950, 850, 600)
days <- c(15, 30, 45, 60, 75, 90, 105)
crop_growth_analysis(dry_weight, leaf_area, days)

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
