% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_split_plot.R
\name{anova_spd_ab_main}
\alias{anova_spd_ab_main}
\title{Split Plot Design with AB in Main Plot}
\usage{
anova_spd_ab_main(
  data,
  response,
  main_factor1,
  main_factor2,
  sub_plot,
  replication,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable}

\item{main_factor1}{First factor in main plot (A)}

\item{main_factor2}{Second factor in main plot (B)}

\item{sub_plot}{Sub-plot factor (C)}

\item{replication}{Name of replication factor}

\item{posthoc}{Post-hoc test method}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table and means
}
\description{
Performs ANOVA for Split Plot Design where main plot contains factorial 
combination of two factors (AB) and sub-plot contains factor C.
Common in irrigation  variety as main plot and nitrogen as sub-plot.
}
\details{
Design structure:
\itemize{
  \item Main Plot: A  B factorial
  \item Sub-Plot: C
  \item Error (a): For testing A, B, and AB
  \item Error (b): For testing C and all interactions with C
}
}
\examples{
data <- data.frame(
  rep = rep(1:3, each = 24),
  irrigation = rep(rep(c("I1", "I2"), each = 12), 3),
  variety = rep(rep(c("V1", "V2", "V3"), each = 4), 6),
  nitrogen = rep(c("N0", "N1", "N2", "N3"), 18),
  yield = rnorm(72, 1200, 150)
)
anova_spd_ab_main(data, response = "yield", 
                  main_factor1 = "irrigation", main_factor2 = "variety",
                  sub_plot = "nitrogen", replication = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
