% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_pd.R
\name{pred_spec_auto}
\alias{pred_spec_auto}
\title{Automatic variable values for dependence}
\usage{
pred_spec_auto(...)
}
\arguments{
\item{...}{names of the variables to use. These can be in quotes
or not in quotes (see examples).}
}
\value{
a character vector with the names
}
\description{
For partial dependence and individual conditional expectations,
this function allows a variable to be considered without having
to specify what values to set the variable at. The values used
are based on quantiles for continuous variables (10th, 25th, 50th,
75th, and 90th) and unique categories for categorical variables.
}
\details{
This function should only be used in the context of
\code{orsf_pd} or \code{orsf_ice} functions.
}
\examples{

fit <- orsf(penguins_orsf, species ~., n_tree = 5)

orsf_pd_oob(fit, pred_spec_auto(flipper_length_mm))

}
