% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{trawl_deriv}
\alias{trawl_deriv}
\title{Estimating the derivative of the trawl function using the
empirical derivative}
\usage{
trawl_deriv(data, Delta, lag = 100)
}
\arguments{
\item{data}{Numeric vector of data used to compute the derivative of the
trawl function}

\item{Delta}{Numeric value specifying the width Delta of the observation grid}

\item{lag}{Integer specifying the lag until which the trawl function
derivative should be estimated. Default is 100.}
}
\value{
Numeric vector of length \code{lag} containing the estimated
derivative values
\eqn{(\hat{a'}(0), \hat{a'}(\Delta), \ldots, \hat{a'}((lag-1) \Delta))}.
}
\description{
This function estimates the derivative of the trawl function using
the empirical derivative of the trawl function.
}
\details{
This function first estimates the trawl function \eqn{\hat{a}(t)}
using \code{\link{nonpar_trawlest}}, then computes the derivative using
finite differences:
\deqn{\widehat{a'}(l\Delta_n) = \frac{\hat{a}((l+1)\Delta_n) -
 \hat{a}(l\Delta_n)}{\Delta_n},} for \eqn{l = 0, 1, \ldots, lag-1}.
}
\examples{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 1000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(123)
#Simulate the trawl process
Poi_data <- sim_weighted_trawl(my_n, my_delta,
                               "Exp", my_lambda, "Poi", my_v)$path

#Estimate the trawl function
my_lag <- 100+1
trawl <- nonpar_trawlest(Poi_data, my_delta, lag=my_lag)$a_hat

#Estimate the derivative of the trawl function
trawl_deriv <- trawl_deriv(Poi_data, my_delta, lag=100)
}
\seealso{
\code{\link{nonpar_trawlest}} for the underlying trawl function
estimation
}
