% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_parallel.r
\name{is_parallel}
\alias{is_parallel}
\alias{is_parallel.Line2D}
\alias{is_parallel.Plane3D}
\title{Whether two objects are parallel}
\usage{
is_parallel(x, y, ...)

\method{is_parallel}{Line2D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{is_parallel}{Plane3D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x, y}{The two objects to compute if they are parallel.}

\item{...}{Passed to other methods (or ignored).}

\item{tolerance}{Numerics with differences smaller
than \code{tolerance} will be considered \dQuote{equivalent}.}
}
\value{
A logical vector.
}
\description{
\code{is_parallel()} is a S3 method that tests whether two objects are parallel.
}
\examples{
line1 <- as_line2d("x-axis")
line2 <- as_line2d("y-axis")
line3 <- as_line2d(a = 0, b = 1, c = 2) # y + 2 = 0
is_parallel(line1, line1)
is_parallel(line1, line2)
is_parallel(line1, line3)
}
