% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\name{adj_edges}
\alias{adj_edges}
\alias{adj_add_edges}
\alias{adj_subtract_edges}
\title{Add and subtract edges from an adjacency list}
\usage{
adj_add_edges(x, v1, v2, ids = NULL)

adj_subtract_edges(x, v1, v2, ids = NULL)
}
\arguments{
\item{x}{An \code{adj} list or object coercible to an \code{adj} list}

\item{v1}{vector of vertex identifiers for the first vertex. Can be an
integer index or a value to look up in \code{ids}, if that argument is provided.
If more than one identifier is present, connects each to corresponding
entry in \code{v2}.}

\item{v2}{vector of vertex identifiers for the second vertex. Can be an
integer index or a value to look up in \code{ids}, if that argument is provided.
If more than one identifier is present, connects each to corresponding
entry in \code{v1}.}

\item{ids}{A vector of unique node identifiers. Each provided vector in \code{v1}
and \code{v2} will be matched to these identifiers. If \code{NULL}, the identifiers
are taken to be 1-indexed integers.}
}
\value{
An \code{adj} list
}
\description{
Add and subtract edges from an adjacency list
}
\examples{
a <- adj(c(2, 3), 1, 1)
adj_add_edges(a, 2, 3)
adj_subtract_edges(a, 1, 2)
}
