% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{rng}
\alias{rng}
\alias{rmultiunit}
\alias{rmultiunit_from_real}
\alias{runit_from_real}
\alias{runit}
\alias{unit_to_real}
\title{Random number generators not available in existing R
  packages}
\usage{
rmultiunit(
  n,
  mean,
  sd,
  Sigma = NULL,
  Omega = NULL,
  perfect_correlation = FALSE
)

rmultiunit_from_real(
  n,
  mean_real,
  sd_real = NULL,
  Sigma_chol = NULL,
  perfect_correlation = FALSE
)

runit_from_real(n, mean_real, sd_real)

runit(n, mean, sd)

unit_to_real(unit_mean, unit_sd)
}
\arguments{
\item{n}{number of random draws to simulate. Each draw is a vector of
values with length equal to \code{length(mean)} and
\code{length(sd)} and the resulting output has \code{n} rows
and \code{length(mean)} columns}

\item{mean}{vector of mean values on the unit scale}

\item{sd}{vector of positive standard deviations}

\item{Sigma}{optional covariance matrix with dimensions of
\code{length(mean)} by \code{length(mean)} defining covariances
between each pair of values in \code{mean}. Note that only
the correlation structure is retained from \code{Sigma},
so that standard deviations are still required}

\item{Omega}{optional correlation matrix with dimensions of
\code{length(mean)} by \code{length(mean)} defining correlations
between each pair of values in \code{mean}}

\item{perfect_correlation}{\code{logical}, if \code{TRUE}
and \code{Sigma} and \code{Omega} are \code{NULL}, then all
values in each replicate (row) are perfectly correlated with known
mean and standard deviation. If \code{FALSE}, then all values
in each replicate are completely uncorrelated}

\item{mean_real}{vector of mean values converted to real-line
equivalents}

\item{sd_real}{vector of standard deviations converted to
real-line equivalents}

\item{Sigma_chol}{Cholesky decomposition of covariance
matrix converted to real-line equivalent}

\item{unit_mean}{vector of mean values on the unit interval}

\item{unit_sd}{vector of standard deviations on the unit
interval}
}
\value{
a vector or matrix of random draws from the \code{r*unit}
  set of functions
}
\description{
Draw random numbers from unusual distributions,
  such as on the unit or non-negative real line with known
  means and standard deviations.
}
\details{
The r*unit family of functions support simulation of values
  on the unit interval based on a known mean, sd, and correlation
  structure. \code{runit} and \code{runit_from_real} are vectorised
  univariate functions, and \code{rmultiunit} and
  \code{rmultiunit_from_real} are multivariate versions of these
  same functions. \code{runit} and \code{rmultiunit} provide
  simulated values on the unit line with specified means, standard
  deviations, and correlation/covariance structure (in the case of
  \code{rmultiunit}).

  The *_from_real versions of these functions are helpers
  that use pre-transformed estimates of parameters on the real
  line, calculated with \code{unit_to_real}. These functions
  are exported because \code{unit_to_real}, called within
  \code{runit} and \code{rmultiunit}, is slow. Separating
  this into a separate step allows less frequent calculations
  of this transformation using function or dynamic versions
  of \code{args} in \code{\link{simulate}}.

  \code{unit_to_real} converts means and standard deviations
  from their values on the unit line to their equivalent
  values on the real line.

  The use of the different versions of these functions is
  illustrated in the Macquarie perch example on the package
  [website](https://aae-stats.github.io/aae.pop/).
}
\examples{
# rmultiunit generates multivariate draws constrained to
#   the unit interval, with known mean, standard deviation,
#   and (optionally) covariance/correlation structure
rmultiunit(n = 10, mean = c(0.25, 0.5, 0.75), sd = c(0.1, 0.4, 0.25))

# add in a correlation structure
omega_set <- cbind(
  c(1, 0.25, 0.01),
  c(0.25, 1, 0.5),
  c(0.01, 0.5, 1)
)
rmultiunit(
  n = 10,
  mean = c(0.25, 0.5, 0.75),
  sd = c(0.1, 0.4, 0.25),
  Omega = omega_set
)
}
