% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{TextUnit}
\alias{TextUnit}
\title{Text Unit}
\description{
A chunk of text from a document
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Unique identifier}

\item{\code{text}}{Text content}

\item{\code{document_id}}{Source document}

\item{\code{chunk_index}}{Index in document}

\item{\code{start_char}}{Start position}

\item{\code{end_char}}{End position}

\item{\code{metadata}}{Additional metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TextUnit-new}{\code{TextUnit$new()}}
\item \href{#method-TextUnit-clone}{\code{TextUnit$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextUnit-new"></a>}}
\if{latex}{\out{\hypertarget{method-TextUnit-new}{}}}
\subsection{Method \code{new()}}{
Create a new TextUnit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextUnit$new(
  id,
  text,
  document_id = NULL,
  chunk_index = 0,
  start_char = 0,
  end_char = 0,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Unique ID}

\item{\code{text}}{Content}

\item{\code{document_id}}{Source doc}

\item{\code{chunk_index}}{Index}

\item{\code{start_char}}{Start}

\item{\code{end_char}}{End}

\item{\code{metadata}}{Metadata}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextUnit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TextUnit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextUnit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
