% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimpute.R
\name{vimpute}
\alias{vimpute}
\title{Impute missing values with prefered Model, sequentially, with hyperparametertuning and with PMM (if wanted)
Need of 'helper_vimpute' script}
\usage{
vimpute(
  data,
  considered_variables = names(data),
  method = setNames(as.list(rep("ranger", length(considered_variables))),
    considered_variables),
  pmm = setNames(as.list(rep(TRUE, length(considered_variables))), considered_variables),
  formula = FALSE,
  sequential = TRUE,
  nseq = 10,
  eps = 0.005,
  imp_var = TRUE,
  pred_history = FALSE,
  tune = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{\itemize{
\item Dataset with missing values. Can be provided as a data.table or data.frame.
}}

\item{considered_variables}{\itemize{
\item A character vector of variable names to be either imputed or used as predictors, excluding irrelevant columns from the imputation process.
}}

\item{method}{\itemize{
\item A named list specifying the imputation method for each variable:
}}

\item{pmm}{\itemize{
\item TRUE/FALSE indicating whether predictive mean matching is used. Provide as a list for each variable.
}}

\item{formula}{\itemize{
\item If not all variables are used as predictors, or if transformations or interactions are required (applies to all X, for Y only transformations are possible). Only applicable for the methods "robust" and "regularized". Provide as a list for each variable that requires specific conditions.
}}

\item{sequential}{\itemize{
\item If TRUE, all variables are imputed sequentially.
}}

\item{nseq}{\itemize{
\item Maximum number of iterations (if sequential is TRUE).
}}

\item{eps}{\itemize{
\item Threshold for convergence.
}}

\item{imp_var}{\itemize{
\item If TRUE, the imputed values are stored.
}}

\item{pred_history}{\itemize{
\item If TRUE, all predicted values across all iterations are stored.
}}

\item{tune}{\itemize{
\item Tunes hyperparameters halfway through iterations, TRUE or FALSE.
}}

\item{verbose}{\itemize{
\item If TRUE additional debugging output is provided
}}
}
\value{
imputed data set or c(imputed data set, prediction history)
}
\description{
Impute missing values with prefered Model, sequentially, with hyperparametertuning and with PMM (if wanted)
Need of 'helper_vimpute' script
}
\examples{
\dontrun{
x <- vimpute(data = sleep, sequential = FALSE)
y <- vimpute(data = sleep, sequential = TRUE, nseq = 3)
z <- vimpute(data = sleep, considered_variables =
       c("Sleep", "Dream", "Span", "BodyWgt"), sequential = FALSE)
}
}
\seealso{
Other imputation methods: 
\code{\link{hotdeck}()},
\code{\link{impPCA}()},
\code{\link{irmi}()},
\code{\link{kNN}()},
\code{\link{matchImpute}()},
\code{\link{medianSamp}()},
\code{\link{rangerImpute}()},
\code{\link{regressionImp}()},
\code{\link{sampleCat}()},
\code{\link{xgboostImpute}()}
}
\concept{imputation methods}
