% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_spatial.R
\name{getSpatialNeighbors_Delaunay}
\alias{getSpatialNeighbors_Delaunay}
\title{Build Spatial Network via Delaunay Triangulation}
\usage{
getSpatialNeighbors_Delaunay(
  coords,
  filter_dist = NA,
  binary = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{coords}{Numeric matrix of spatial coordinates.
Rows are spatial locations, columns are x, y (and optionally z) coordinates.}

\item{filter_dist}{Numeric or NA. Maximum distance threshold for neighbors.
Default is NA (no filtering).}

\item{binary}{Logical. If TRUE (default), return binary adjacency matrix.}

\item{verbose}{Logical. Whether to print progress messages. Default is FALSE.}
}
\value{
Square numeric matrix of spatial adjacency weights.
}
\description{
Constructs a spatial adjacency matrix using Delaunay triangulation.
Two points are considered neighbors if they share an edge in the triangulation.
}
\details{
The function uses Delaunay triangulation from the \code{geometry} package.
For 2D coordinates, this creates triangles. For 3D, it creates tetrahedra.

Duplicate coordinates are slightly jittered to avoid computational issues.
}
\examples{
set.seed(42)
coords <- cbind(x = runif(50), y = runif(50))
rownames(coords) <- paste0("spot_", 1:50)

\donttest{
if (requireNamespace("geometry", quietly = TRUE)) {
    W <- getSpatialNeighbors_Delaunay(coords)
}
}

}
