% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_utils.R
\name{formula_from_vars}
\alias{formula_from_vars}
\title{Generate model formula by specifying which variables have totals or not.}
\usage{
formula_from_vars(
  nontotal_vars = NULL,
  total_vars = NULL,
  simplify = TRUE,
  env = parent.frame()
)
}
\arguments{
\item{nontotal_vars}{character vector of the variable names without totals}

\item{total_vars}{character vector of the variable names with totals}

\item{simplify}{logical value, default TRUE. Determines whether the formula
should be simplified before output or not.}

\item{env}{the environment for the output formula}
}
\value{
model formula
}
\description{
Generate model formula by specifying which variables have totals or not.
}
\examples{
formula_from_vars(c("a", "b", "c"), c("a"))
formula_from_vars(c("a", "b", "c"), c("a", "c"))
formula_from_vars(c("a", "b", "c"), c("a", "b", "c"))
formula_from_vars(c("a", "b", "c"), NULL)
formula_from_vars(NULL, c("a", "b", "c"))
formula_from_vars(c("a", "b"), c("d"))
}
\author{
Daniel Lupp
}
\keyword{internal}
