% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRMed.R
\name{LRMed}
\alias{LRMed}
\title{Calculate the CDE, NDE and NIE (linear models, binary exposure).}
\usage{
LRMed(data, exposure, mediator, outcome, confounderVec, mValue)
}
\arguments{
\item{data}{A data frame.}

\item{exposure}{The name of the exposure (must be a binary variable).}

\item{mediator}{The name of the mediator (must be a continuous variable).}

\item{outcome}{The name of the outcome (must be a continuous variable).}

\item{confounderVec}{The name vector of the confounders.}

\item{mValue}{The controlled mediator value for CDE estimation.}
}
\value{
A list of exposure-outcome model, exposure-mediator model, CDE, NDE and NIE and their asymptotic variances.
}
\description{
Calculate the CDE, NDE and NIE (linear models, binary exposure).
}
\examples{
medModel <- LRMed(data = data.sim.med,
                  exposure = "pesticide1", mediator = "hormone", outcome = "ySim",
                  confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
                                    "season2", "season3", "season4", "smoking1", "ovum1",
                                    "diabetes1"),
                  mValue = 0.15)
medModel
}
