% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{worldclim}
\alias{worldclim}
\title{Bioclimatic Variables from WorldClim (bio_1, bio_7, bio_12)}
\format{
A \code{SpatRaster} with 3 layers and the following characteristics:
\describe{
\item{Dimensions}{151 rows × 183 columns}
\item{Resolution}{0.08333333° × 0.08333333°}
\item{Extent}{xmin = -57.08333, xmax = -41.83333,
ymin = -32.08333, ymax = -19.5}
\item{CRS}{WGS84 (EPSG:4326)}
\item{Layers}{
\describe{
\item{bio_1}{Mean Annual Temperature (°C × 10)}
\item{bio_7}{Temperature Annual Range (°C × 10)}
\item{bio_12}{Annual Precipitation (mm)}
}
}
}
}
\source{
\url{https://www.worldclim.org/}
}
\usage{
worldclim
}
\description{
A \code{PackedSpatRaster} containing three bioclimatic variables from the
WorldClim, cropped to a region of interest South America.
}
\details{
This raster corresponds to three standard bioclimatic variables from the
\strong{WorldClim 2.1} dataset.
}
\examples{
data(worldclim)
bioclim <- terra::unwrap(worldclim)
terra::plot(bioclim)
}
\keyword{datasets}
