% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_flags.R
\name{summarize_flags}
\alias{summarize_flags}
\title{Summarize flags}
\usage{
summarize_flags(
  occ = NULL,
  flagged_dir = NULL,
  output_format = ".gz",
  flags = "all",
  additional_flags = NULL,
  names_additional_flags = NULL,
  plot = TRUE,
  show_unflagged = TRUE,
  occ_unflagged = NULL,
  fill = "#0072B2",
  sort = TRUE,
  decreasing = TRUE,
  add_n = TRUE,
  size_n = 3.5,
  theme_plot = ggplot2::theme_minimal(),
  ...
)
}
\arguments{
\item{occ}{(data.frame or data.table) a dataset containing occurrence records
that has been processed by one or more flagging functions. See \emph{Details} for
available flag types.}

\item{flagged_dir}{(character) optional path to a directory containing files
with flagged records saved using the \code{remove_flagged()} function. Default is
\code{NULL}.}

\item{output_format}{(character) output format used to read the removed records.
Options are \code{".csv"} or \code{".gz"}. Only used when \code{flagged_dir} is not \code{NULL}.
Default is \code{".gz"}.}

\item{flags}{(character) the flags to be summarized. Use \code{"all"} to display
all available flags. See \emph{Details} for all options. Default is \code{"all"}.}

\item{additional_flags}{(character) an optional named character vector with
the names of additional logical columns to be used as flags. Default is \code{NULL}.}

\item{names_additional_flags}{(character) an optional different name to the
flag provided in \code{additional_flags} to be shown in the map. Only applicable
if \code{additional_flags} is not NULL.}

\item{plot}{(logical) whether to return a \code{ggplot2} bar plot showing the
number of flagged records. Default is \code{TRUE}.}

\item{show_unflagged}{(logical) whether to include the number of unflagged
records in the plot. Default is \code{TRUE}.}

\item{occ_unflagged}{(data.frame or data.table) an optional dataset
containing unflagged occurrence records. Only applicable if \code{occ} is NULL and
\code{show_unflagged} is \code{TRUE}.}

\item{fill}{(character) fill color for the bar plot. Default is \code{"#0072B2"}.}

\item{sort}{(logical) whether to sort bars according to the number of records.
Default is \code{TRUE}.}

\item{decreasing}{(logical) whether to sort bars in decreasing order (flags
with more records appear at the top of the plot). Default is \code{TRUE}.}

\item{add_n}{(logical) whether to display the number of flagged records on
the bars. Default is \code{TRUE}.}

\item{size_n}{(numeric) size of the text showing the number of records. Only
used when \code{add_n = TRUE}. Default is \code{3.5}.}

\item{theme_plot}{(theme) a \code{ggplot2} theme object. Default is
\code{ggplot2::theme_minimal()}.}

\item{...}{additional arguments passed to \code{ggplot2::theme()}.}
}
\value{
If \code{plot = TRUE}, a list with two elements:
\describe{
\item{df_summary}{A data frame summarizing the number of records per flag.}
\item{plot_summary}{A \code{ggplot2} object showing the summary as a bar plot.}
}
If \code{plot = FALSE}, only the summary data frame is returned.
}
\description{
This functions returns a dataframe and a bar plot summarizing the number of
records flagged by each flagging function.
}
\details{
This function expects an occurrence dataset that has already been processed
by one or more flagging routines from \strong{RuHere} or related packages such as
\strong{CoordinateCleaner}. Any logical column in \code{occ} can be used as a flag.

The following built-in flag names are recognized:
\emph{From RuHere}:
\code{correct_country}, \code{correct_state}, \code{cultivated}, \code{florabr}, \code{faunabr},
\code{wcvp}, \code{iucn}, \code{bien}, \code{duplicated}, \code{thin_geo}, \code{thin_env}, \code{consensus}

\emph{From CoordinateCleaner}:
\code{.val}, \code{.equ}, \code{.zer}, \code{.cap}, \code{.cen}, \code{.sea}, \code{.urb}, \code{.otl}, \code{.gbf},
\code{.inst}, \code{.aohi}

Users may also supply additional logical columns using
\code{additional_flags}, optionally providing alternative display names
(\code{names_additional_flags}) and colors (\code{col_additional_flags}).
}
\examples{
# Load example data
data("occ_flagged", package = "RuHere")
# Summarize flags
sum_flags <- summarize_flags(occ = occ_flagged)
# Plot
sum_flags$plot_summary
}
