% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{relocate_after}
\alias{relocate_after}
\alias{relocate_before}
\title{Relocate a column in a data frame}
\usage{
relocate_after(df, col, after)

relocate_before(df, col, before)
}
\arguments{
\item{df}{(data.frame) a data.frame whose columns will be reordered.}

\item{col}{(character) the name of the column to move.}

\item{after}{(character) for \code{relocate_after()}: the column after which
\code{col} will be placed.}

\item{before}{(character) for \code{relocate_before()}: the column before which
\code{col} will be placed.}
}
\value{
A data.frame with columns reordered.
}
\description{
These functions move one column to a new position in a data frame,
either immediately \emph{after} or \emph{before} another column, while preserving
the order of all remaining columns. They are lightweight base-R utilities
equivalent to \code{dplyr::relocate()}, but without external dependencies.
}
