% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_gbif.R
\name{import_gbif}
\alias{import_gbif}
\title{Import a download requested from GBIF}
\usage{
import_gbif(
  request_key,
  write_file = FALSE,
  output_dir = NULL,
  file.format = "gz",
  select_columns = TRUE,
  columns_to_import = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{request_key}{an object of class 'request_key' returned by the
\code{request_gbif()} function.}

\item{write_file}{whether to save the downloaded occurrences to disk.
Default is FALSE. If TRUE, you must specify the \code{output_dir}.}

\item{output_dir}{(character) a directory to save the data downloaded from
GBIF. Only applicable if \code{write_file = TRUE}. Default is NULL.}

\item{file.format}{(character) the format to save the file. Options available
are 'csv' (comma-separated values) and 'gz' (compressed GZIP). Only
applicable if \code{write_file = TRUE}. Default is 'gz'.}

\item{select_columns}{(logical) whether to import only specific columns (TRUE)
or all columns (FALSE) from the occurrence table. Default is TRUE.}

\item{columns_to_import}{(character) vector of column names to import.
Default is NULL, meaning it will import the column names specified in
\code{RuHere::gbif_columns} data.}

\item{overwrite}{(logical) whether to overwrite the file in the 'output_dir'
if it already exists. Default is FALSE.}

\item{...}{other arguments passed to \code{rgbif::occ_download_import()}.}
}
\value{
A data frame containing the GBIF occurrence records. If \code{write_file = TRUE},
the function also saves the dataset to disk in the specified format.
}
\description{
This function imports a dataset downloaded from GBIF using a request key
generated by the \code{request_gbif()} function. It optionally allows saving
the imported occurrences to disk in CSV or GZIP format.
}
\note{
This function requires an active internet connection.
}
\examples{
 \dontrun{
# Prepare data to request GBIF download
gbif_prepared <- prepare_gbif_download(species = "Araucaria angustifolia")
# Submit a request to download occurrences
gbif_requested <- request_gbif(gbif_info = gbif_prepared)
# Check progress
rgbif::occ_download_wait(gbif_requested)
# After succeeded, import data
occ_gbif <- import_gbif(request_key = gbif_requested)
}
}
