% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggrid_here.R
\name{ggrid_here}
\alias{ggrid_here}
\title{Static Visualization of Richness and Trait Maps}
\usage{
ggrid_here(
  raster,
  low_color = "blue",
  mid_color = "yellow",
  high_color = "red",
  alpha = 0.8,
  continent = NULL,
  continent_fill = "gray70",
  continent_linewidth = 0.3,
  continent_border = "white",
  ocean_fill = "aliceblue",
  extension = NULL,
  theme_plot = ggplot2::theme_minimal(),
  ...
)
}
\arguments{
\item{raster}{(SpatRaster) A raster object generated by \code{richness_here()}.}

\item{low_color}{(character) color for the lowest values. Default is "blue".}

\item{mid_color}{(character) color for the midpoint. Default is "yellow".}

\item{high_color}{(character) color for the highest values. Default is "red".}

\item{alpha}{(numeric) transparency of the grid (0-1). Default is 0.8.}

\item{continent}{(SpatVector) optional polygon layer for boundaries.}

\item{continent_fill}{(character) fill color for continents. Default is "gray70".}

\item{continent_linewidth}{(numeric) line width for continent boundaries.
Default is 0.3.}

\item{continent_border}{(character) color of the continent polygon borders.
Default is "white".}

\item{ocean_fill}{(character) background color for the ocean. Default is "aliceblue".}

\item{extension}{(SpatExtent or numeric) optional map extent.}

\item{theme_plot}{(theme) a \code{ggplot2} theme object.}

\item{...}{other arguments passed to \code{ggplot2::theme()}.}
}
\value{
A ggplot object.
}
\description{
This function is the dedicated plotting tool for outputs from \code{richness_here()}.
It automatically handles single-layer rasters (e.g., species richness) and
multi-layer rasters (e.g., multiple biological traits or flags), creating
a standardized visual using \strong{ggplot2}.
}
\examples{
# Load example data
data("occ_flagged", package = "RuHere")

# Simple richness map
r_records <- richness_here(occ_flagged, summary = "records", res = 2)
ggrid_here(r_records)

# Density of specific flags
# Let's see where 'florabr' flags are concentrated
r_flags <- richness_here(occ_flagged, summary = "records",
                         field = "florabr_flag",
                         field_name = "Records flagged by florabr",
                         fun = function(x, ...) sum(!x, na.rm = TRUE),
                         res = 2)
ggrid_here(r_flags)

}
