% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bien.R
\name{get_bien}
\alias{get_bien}
\title{Download occurrence records from BIEN}
\usage{
get_bien(by = "species", cultivated = FALSE,
new.world = NULL, all.taxonomy = FALSE, native.status = FALSE,
natives.only = TRUE, observation.type = FALSE, political.boundaries = TRUE,
collection.info = TRUE, only.geovalid = TRUE, min.lat = NULL, max.lat = NULL,
min.long = NULL, max.long = NULL, species = NULL, genus = NULL,
country = NULL, country.code = NULL, state = NULL, county = NULL,
state.code = NULL, county.code = NULL, family = NULL, sf = NULL, dir,
filename = "bien_output", file.format = "csv", compress = FALSE,
save = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{by}{(character) type of query to perform (\code{"box"}, \code{"country"},
\code{"county"}, \code{"family"}, \code{"genus"}, \code{"records_per_species"}, \code{"species"},
\code{"sf"}, or \code{"state"}). Default is \code{species}.}

\item{cultivated}{(logical) whether to include cultivated records or exclude
them. Default is \code{FALSE}.}

\item{new.world}{(logical) if \code{TRUE}, restricts records to the New World,
if \code{FALSE}, to the Old World, and if \code{NULL}, no restriction. Default is \code{NULL}.}

\item{all.taxonomy}{(logical) if \code{TRUE}, returns all taxonomic levels
available, otherwise, limits results to accepted names. Default is \code{FALSE}.}

\item{native.status}{(logical) if \code{TRUE}, includes information about native
versus non-native status of occurrences. Default is \code{FALSE}.}

\item{natives.only}{(logical) if \code{TRUE}, restricts results to native species
only. Default is \code{TRUE}.}

\item{observation.type}{(logical) if \code{TRUE}, includes information on
observation types. Default is \code{FALSE}.}

\item{political.boundaries}{(logical) if \code{TRUE}, restricts the search to
defined political boundaries. Default is \code{TRUE}.}

\item{collection.info}{(logical) if \code{TRUE}, includes collection-level
metadata. Default is \code{TRUE}.}

\item{only.geovalid}{(logical) if \code{TRUE}, restricts output to
georeferenced and spatially valid records. Default is \code{TRUE}.}

\item{min.lat}{(numeric) the minimum latitude (in decimal degrees) for a
bounding-box query when \code{by = "box"}.}

\item{max.lat}{(numeric) the maximum latitude (in decimal degrees) for a
bounding-box query when \code{by = "box"}.}

\item{min.long}{(numeric) the minimum longitude (in decimal degrees) for a
bounding-box query when \code{by = "box"}.}

\item{max.long}{(numeric) the maximum longitude (in decimal degrees) for a
bounding-box query when \code{by = "box"}.
Ignored otherwise. Default is \code{NULL}.}

\item{species}{(character) species name(s) to query when \code{by = "species"}
or \code{"records_per_species"}. Default is \code{NULL}.}

\item{genus}{(character) genus name(s) to query when \code{by = "genus"}. Default
is \code{NULL}.}

\item{country}{(character) country name when \code{by = "country"}, \code{"state"},
or \code{"county"}. Default is \code{NULL}.}

\item{country.code}{(character) two-letter ISO country code corresponding
to \code{country}. Default is \code{NULL}.}

\item{state}{(character) state or province name when \code{by = "state"} or
\code{"county"}. Default is \code{NULL}.}

\item{county}{(character) county or equivalent subdivision name
when \code{by = "county"}. Default is \code{NULL}.}

\item{state.code}{(character) state or province code corresponding
to \code{state}. Default is \code{NULL}.}

\item{county.code}{(character) county or equivalent subdivision code
corresponding to \code{county}. Default is \code{NULL}.}

\item{family}{(character) family name(s) to query when \code{by = "family"}.
Default is \code{NULL}.}

\item{sf}{(object of class \code{sf}) a spatial object defining an area
of interest when \code{by = "sf"}.  Default is \code{NULL}.}

\item{dir}{(character) directory path where the file will be saved.
Required if \code{save = TRUE}.}

\item{filename}{(character) name of the output file without extension.
Default is \code{"bien_output"}.}

\item{file.format}{(character) file format for saving output (\code{"csv"},
\code{"rds"}).
Default is \code{"csv"}.}

\item{compress}{(logical) if \code{TRUE} and \code{save = TRUE}, compresses the output
file as .csv.zip. Default is \code{FALSE}.}

\item{save}{(logical) if \code{TRUE}, saves the results to a CSV file.
Default is \code{FALSE}.}

\item{verbose}{(logical) if \code{TRUE}, prints messages about the progress and
the number of species being checked. Default is \code{TRUE}.}

\item{...}{additional arguments passed to the underlying BIEN function.}
}
\value{
A \code{data.frame} containing BIEN occurrence records that match
the specified query. The structure and available columns depend on the chosen
\code{by} value and the corresponding BIEN function.
}
\description{
Wrapper function to access and download occurrence records from the
Botanical Information and Ecology Network (BIEN) database. It provides a
unified interface to query BIEN data by species, genus, family, or by
geographic or political boundaries.
}
\examples{
\donttest{
# Example: download occurrence records for a single species
res_test <- get_bien(
    by = "species",
    species = "Paubrasilia echinata",
    cultivated = TRUE,
    native.status = TRUE,
    observation.type = TRUE,
    only.geovalid = TRUE
)
}

}
