% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{custom_modulelist_from_org}
\alias{custom_modulelist_from_org}
\title{Custom modulelist from a specific organism}
\usage{
custom_modulelist_from_org(
  org = "hsa",
  feature = "ko",
  gene = "symbol",
  verbose = TRUE
)
}
\arguments{
\item{org}{kegg organism, listed in https://www.genome.jp/kegg/catalog/org_list.html, default, "hsa"}

\item{feature}{one of "ko", "gene", "compound"}

\item{gene}{one of "symbol","id"}

\item{verbose}{logical}
}
\value{
modulelist
}
\description{
Custom modulelist from a specific organism
}
\examples{
hsa_pathway <- custom_modulelist_from_org(org = "hsa", feature = "gene")
}
\seealso{
Other modulelist: 
\code{\link{custom_modulelist}()},
\code{\link{get_features}()}
}
\concept{modulelist}
