% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealSurvSim.R
\name{data_simul_Estim}
\alias{data_simul_Estim}
\title{Simulate Data Based on Parametric Distribution Estimates}
\usage{
data_simul_Estim(orig_vals, n = NULL, distrib = "exp")
}
\arguments{
\item{orig_vals}{Numeric vector of values from the original dataset.}

\item{n}{Integer specifying the number of observations to simulate. If \code{NULL}, the function simulates
the same number of observations as in the original dataset. Defaults to \code{NULL}.}

\item{distrib}{Character; one of "inverse_gamma", "llogis", "gumbel",
"exp", "gamma", "normal", or "cauchy".}
}
\value{
Numeric vector of \code{n} simulated values based on the fitted parametric distribution.
}
\description{
This function simulates data based on parameter estimates from a specified parametric distribution.
It fits a chosen distribution to the original dataset and samples new values from this fitted distribution.
Supported distributions include "inverse_gamma", "llogis" (log-logistic), "gumbel". "log-normal", "gamma", "exp", "cauchy".
}
\examples{
original_data <- rnorm(100, mean = 50, sd = 10)
simulated_data <- data_simul_Estim(orig_vals = original_data, n = 100, distrib = "inverse_gamma")
}
