% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oibeta2.R
\name{oibeta2}
\alias{oibeta2}
\alias{doibeta2}
\alias{poibeta2}
\alias{roibeta2}
\title{Reparameterised one-inflated beta distribution}
\usage{
doibeta2(x, mu, phi, oneprob = 0, log = FALSE)

poibeta2(q, mu, phi, oneprob = 0, lower.tail = TRUE, log.p = FALSE)

roibeta2(n, mu, phi, oneprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{mean parameter, must be in the interval from 0 to 1.}

\item{phi}{concentration parameter, must be positive.}

\item{oneprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{doibeta2} gives the density, \code{poibeta2} gives the distribution function, and \code{roibeta2} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the one-inflated beta distribution reparameterised in terms of mean and concentration.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- roibeta2(1, 0.6, 2, 0.5)
d <- doibeta2(x, 0.6, 2, 0.5)
p <- poibeta2(x, 0.6, 2, 0.5)
}
