% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{cgumbel}
\alias{cgumbel}
\alias{Cgumbel}
\title{Gumbel copula constructors}
\usage{
cgumbel(theta)

Cgumbel(theta)
}
\arguments{
\item{theta}{Dependence parameter (\eqn{\theta >= 1}).}
}
\value{
A function of two arguments \code{(u, v)} returning either
the log copula density (\code{cgumbel}) or the copula CDF (\code{Cgumbel}).
}
\description{
Construct functions that compute either the log density or the CDF
of the bivariate Gumbel copula, intended for use with \code{\link{dcopula}}.
}
\details{
The Gumbel copula density

\deqn{
c(u,v;\theta) = \exp\Big[-\big((-\log u)^\theta + (-\log v)^\theta\big)^{1/\theta}\Big] \cdot h(u,v;\theta),
}
where \eqn{h(u,v;\theta)} contains the derivative terms ensuring the function is a density.
}
\examples{
x <- c(0.5, 1); y <- c(0.2, 0.4)
d1 <- dnorm(x, 1, log = TRUE); d2 <- dbeta(y, 2, 1, log = TRUE)
p1 <- pnorm(x, 1); p2 <- pbeta(y, 2, 1)
dcopula(d1, d2, p1, p2, copula = cgumbel(1.5), log = TRUE)

# CDF version (for discrete copulas)
Cgumbel(1.5)(0.5, 0.4)
}
\seealso{
\code{\link[=cgaussian]{cgaussian()}}, \code{\link[=cclayton]{cclayton()}}, \code{\link[=cfrank]{cfrank()}}
}
