% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_get_estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Extract estimates from RSTr model object}
\usage{
get_estimates(RSTr_obj, rates_per = 1e+05, standardized = TRUE)
}
\arguments{
\item{RSTr_obj}{An \code{RSTr} model object.}

\item{rates_per}{The desired scaling for estimate rates.}

\item{standardized}{If \code{RSTr_obj} contains age-standardized rates, shows the age-standardized rates. If set to \code{FALSE}, always shows the non-age-standardized rates.}
}
\value{
A long \code{table} containing region/group/time period names, estimates, credible intervals, relative precisions, and the associated event/population counts.
}
\description{
Gathers model and estimate information for an \code{RSTr} model object, exported as a long table. Estimate rates and their respective credible intervals are displayed by default in rates per 100,000.
}
\examples{
std_pop <- c(113154, 100640, 95799)
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
on.exit(unlink(file.path(tempdir(), "test"), recursive = TRUE), add = TRUE)
mod_mst <- mstcar("test", data_min, adj_min, tempdir(), show_plots = FALSE, verbose = FALSE)
estimates_table <- get_estimates(mod_mst)
mod_mst <- age_standardize(mod_mst, std_pop, "35-64")
estimates_table_as <- get_estimates(mod_mst)
}
