% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEstimates.R
\name{plotEstimates}
\alias{plotEstimates}
\title{Plot estimates from regression model used for risk-adjustment}
\usage{
plotEstimates(model.performance)
}
\arguments{
\item{model.performance}{results from \code{model_performance()}}
}
\value{
A ggplot figure
}
\description{
This function creates a plot of model results
}
\examples{
# Simulate data
df <- simulateData(n.entity = 100, n.obs = 80, mu = 0.2, r = 0.6, beta1 = log(1.6))

# Calculate risk-adjustment model performance
model.perf <- model_performance(df = df, model = 'y ~ x1 + (1|entity)')

# Plot estimated effects of predictors
plotEstimates(model.perf)


}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
