% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.profileLadder.R
\name{predict.profileLadder}
\alias{predict.profileLadder}
\title{One-year-ahead prediction based on PARALLAX, REACT, or MACRAME}
\usage{
\method{predict}{profileLadder}(object, ...)
}
\arguments{
\item{object}{an object of the class \code{profileLadder} which is the output
from the \code{parallelReserve()} function or the \code{mcReserve} function}

\item{...}{further arguments passed to \code{predict()}}
}
\value{
An object of the class \code{profilePredict} which is a list with
the following elements:
\item{reserve}{The overall predicted amount of the next year payments---the new
running diagonal in an extended (cumulative) run-off triangle minus the last
observed diagonal (in the cumulative triangle again)}
\item{methods}{Provides the information about the underlying nonparametric
(functional-based) method that is used  for the 1-year-ahead prediction (PRALLAX,
REACT, or MACRAME)}
\item{newDiagonal}{Numeric vector representing the prediction of the new running
diagonal (ordered in a way that first value corresponds to the payment for the last
occurrence period (typically the largest amount) and the last value corresponds
with the next-year payment for the first occurrence periods---typically the smallest
amount)}
\item{extTriangle}{The extended run-off triangle---the R object of the class
\code{triangle} that also contains the new predicted diagonal---the 1-year-ahead
prediction}
}
\description{
The function provides a one-year-ahead prediction for a given run-off triangle
(i.e., estimating a new running diagonal based on some nonparametric, functional-based
prediction algorithm, PARALLAX, REACT, or MACRAME).
}
\examples{
## full run-off triangle complettion
parallelReserve(CameronMutual)

## one-year-ahead prediction based on PARALLAX
predict(parallelReserve(CameronMutual))

}
\seealso{
\code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}
}
